//	CFolderWindow.c

#include "ADFS_Menus.h"
#include "ADFS_Commands.h"
#include "CEntry.h"
#include "CFolderWindow.h"

#define kFolderWindowID			128

CFolderWindow		*MakeNewFolderWindow(O_TopicRef *topicRef)
{
	CFolderWindow	*window = new CFolderWindow;
	
	if (window) {
		if (!window->IFolderWindow(topicRef)) {
			window->Dispose();
			window = NULL;
		}
	}

	return window;
}

Boolean		CFolderWindow::IFolderWindow(
		O_TopicRef	*topicRef)
{
	Boolean		success = TRUE;
	char		buf[256];
	
	success = _inherited::IFinderWindow(ADFS_Window_FOLDER, kFolderWindowID, topicRef);
	
	GetTopicEntry(i_topicRef.cTopic)->GetName(buf);
	SetTitle(buf);

	return success;
}

void		CFolderWindow::Dispose(void)
{
	Prepare();
	CRenameTextEdit::FinishRename();
	UnPrepare();

	GetTopicEntry(i_topicRef.cTopic)->i_window = NULL;

	_inherited::Dispose();
}

void		CFolderWindow::UpdateMenus(void)
{
	EnableCommand(cmdCloseWindow);

	_inherited::UpdateMenus();
}

Boolean		CFolderWindow::DoCommand(long command)
{
	Boolean			handled = FALSE;
	
	switch (command) {
		
		default: {
			handled = _inherited::DoCommand(command);
			break;
		}
	}

	return handled;
}

